state Dreamer_Dreaming in W3MagicDreamer
{
	var upd_beh			: bool;

	event OnEnterState( prevStateName : name )
	{
		parent.active = false;
		parent.hand_effects_active = false;
		
		unregister_swordless_input_spells();
		
		GetMagicEffectLeft().StopEffect( parent.hand_effects );
		GetMagicEffectRight().StopEffect( parent.hand_effects );
		
		//theGame.witcherLog.AddMessage("SWORDLESS DEINIT   "  );
		
		if ( parent.should_revert_setting )
		{
			if ( theGame.GetInGameConfigWrapper().GetVarValue('Gameplay', 'DisableAutomaticSwordSheathe') )
			{
				theGame.GetInGameConfigWrapper().SetVarValue('Gameplay', 'DisableAutomaticSwordSheathe', parent.original_setting );
			}
		}
		
		clean_behavior();
	}
	
	private entry function clean_behavior()
	{	
		upd_beh = true;
	
		while ( upd_beh )
		{
			//theGame.witcherLog.AddMessage("CHECK BEHAVIOR"  );
		
			if ( thePlayer.GetBehaviorVariable( 'playerWeapon' ) == (int) PW_Steel 
				&& !thePlayer.IsWeaponHeld( 'steelsword' ) 
				&& !thePlayer.IsWeaponHeld( 'playerSecondary' ) 
				&& !thePlayer.IsInCombat() )
			{
				thePlayer.GetWeaponHolster().UpdateBehGraph();
			}
			else
			{
				upd_beh = false;
			}
			
			Sleep(0.1);
		}
	}
}

state Dreamer_Waiting in W3MagicDreamer
{
	event OnEnterState( prevStateName : name )
	{
		//theGame.witcherLog.AddMessage("Dreamer_Waiting");
	
		thePlayer.BlockAllActions( 'MagicSpells', false);		

		parent.swordless_state_name = '';
		parent.swordless_spell_name = '';
		parent.leftanim = false;

		parent.actor = NULL;
		parent.actor_ag = NULL;

		GetMagicVigil().set_is_in_custom_anim(false);
		
		parent.can_cast_swordless_animation = true;
		parent.can_cast_swordless_guard = true;
		
		if ( parent.apply_item_hack )
		{
			parent.RemoveTimer('raise_event_hack_end');
			parent.AddTimer('raise_event_hack_end',0.f );
		}
		
		parent.RemoveTimer( 'rotate_towards_target_swordless' );
		parent.RemoveTimer( 'find_n_rotate_towards_target' );
		
		theGame.GetEntityByTag( 'swordless_heavy_fx_ent' ).AddTimer('destroy_sw_heavy', 0 );
		
		spells_dreamer_watcher();
	}
	
	private entry function spells_dreamer_watcher()
	{
		while( true && parent.active )
		{
			if ( thePlayer.GetBehaviorVariable( 'playerWeapon' ) == (int) PW_Fists )
			{
				thePlayer.SetBehaviorVariable( 'playerWeapon', (int) PW_Steel );
				thePlayer.SetBehaviorVariable( 'playerWeaponForOverlay', (int) PW_Steel );
				thePlayer.SetBehaviorVariable( 'playerWeaponLatent', thePlayer.GetBehaviorVariable( 'playerWeapon' ) );
			}
			
			parent.swordless_hand_effects();
		
			Sleep(0.1f);
		}
	}
}


state Dreamer_Casting in W3MagicDreamer
{
	var actionBlockingExceptions : array<EInputActionBlock>;
	
	event OnEnterState( prevStateName : name )
	{
		parent.swordless_hand_effects();
	
		theGame.GetBehTreeReactionManager().CreateReactionEventIfPossible( thePlayer, 'CastSignAction', -1, 8.0f, -1.f, -1, true );
	
		actionBlockingExceptions.PushBack( EIAB_Movement 		);
		actionBlockingExceptions.PushBack( EIAB_RunAndSprint 	);
	  //actionBlockingExceptions.PushBack( EIAB_Roll 			);		
	  //actionBlockingExceptions.PushBack( EIAB_Dodge 			);
		actionBlockingExceptions.PushBack( EIAB_Climb 			);
		actionBlockingExceptions.PushBack( EIAB_Slide 			);
		actionBlockingExceptions.PushBack( EIAB_Sprint		 	);
	  //actionBlockingExceptions.PushBack( EIAB_Parry 			);
	  
		thePlayer.BlockAllActions( 'MagicSpells', true, actionBlockingExceptions );
		
		GetMagicVigil().set_is_in_custom_anim(true);
		GetMagicVigil().set_can_interrupt(false);
		
		//theGame.witcherLog.AddMessage("Dreamer_Casting");
		
		if ( parent.apply_item_hack )
		{
			parent.RemoveTimer('raise_event_hack_end');
			parent.AddTimer('raise_event_hack_end',0.f );
		}
		
		parent.actor = NULL;
		parent.actor_ag = NULL;

		
		//if ( (CActor)thePlayer.GetDisplayTarget() )
		//{
		//	parent.actor = (CActor)thePlayer.GetDisplayTarget();	
		//}
		
		theGame.GetEntityByTag( 'swordless_heavy_fx_ent' ).AddTimer('destroy_sw_heavy', 0 );
		
		parent.GotoState( parent.swordless_state_name );
	}
}

state Swordless_guard in W3MagicDreamer
{
	var effect 						: CEntity;
	var entities 					: array<CGameplayEntity>;
	var victim 						: CActor;
	var damage_action 				: W3DamageAction;
	var i							: int;

	event OnEnterState( prevStateName : name )
	{	
		//theGame.witcherLog.AddMessage("Swordless_guard");
	
		if ( !theSound.SoundIsBankLoaded("monster_wraith.bnk") )
		{
			theSound.SoundLoadBank( "monster_wraith.bnk", false );
		}
	
		if ( parent.swordless_spell_name == 'guard_spell' )
		{
			parent.can_cast_swordless_guard = false;
			parent.can_cast_swordless_animation = false;
			swordless_cast_guard();
		}
	}
	
	private entry function swordless_cast_guard()
	{
		parent.sett.blendIn = 0.2f;
		parent.sett.blendOut = 0.5f;
		thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_mage_root_attack_start2', 'PLAYER_SLOT', parent.sett );
		thePlayer.SoundEvent("monster_wraith_VFX_shadows_form");
		
		effect = thePlayer.CreateFXEntityAtBone( 'swordless_effects', 'head', false );
		effect.PlayEffect('swordless_guard');
		effect.DestroyAfter(3);
		
		entities.Clear();
		FindGameplayEntitiesInCylinder(entities, thePlayer.GetWorldPosition(), 3, 4, 100,, FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		if( entities.Size()>0 )
		{
			for( i = 0; i < entities.Size(); i += 1 )
			{
				entities[i].OnAardHit( NULL );
				victim = (CActor)entities[i];
				if(victim && GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile )									
				{
					damage_action =  new W3DamageAction in this;
					damage_action.Initialize( thePlayer, victim, this, thePlayer.GetName()+"_sign", EHRT_None, CPS_Undefined, false, false, true, false);
					damage_action.SetProcessBuffsIfNoDamage(true);
					damage_action.SetHitEffect('');
					damage_action.SetHitEffect('', true );
					damage_action.SetHitEffect('', false, true);
					damage_action.SetHitEffect('', true, true);
				
					damage_action.AddEffectInfo( EET_Stagger );
					theGame.damageMgr.ProcessAction( damage_action );
					delete damage_action;
				}
			}
		}
		
		Sleep (0.3);
		parent.can_cast_swordless_guard = true;
		parent.can_cast_swordless_animation = true;
		GetMagicVigil().set_can_interrupt(true);
		
		Sleep( 0.5 );
		parent.GotoState('Dreamer_Waiting');
	}
}

state Swordless_AttackLight in W3MagicDreamer
{
	var animname							: name;
	var effect								: CEntity;
	var frozenbolt							: W3BoltSpellsfrozen;
	var aardproj 							: W3AardTrailM;
	var meshComponent 						: CMeshComponent;
	var path								: string;
	var pos 								: Vector;
	var rot 								: EulerAngles;
	var effname								: name;
	var effect_entity						: CEntity;

	event OnEnterState( prevStateName : name )
	{	
		parent.AddTimer('rotate_towards_target_swordless', 0.01, true );
		
		parent.sett.blendIn = 0.5f;
		parent.sett.blendOut = 0.5f;
	
		parent.can_cast_swordless_animation = false;
		swordless_light_attack();
		
	}


	private entry function swordless_light_attack()
	{
		switch( GetWitcherPlayer().GetEquippedSign() )
		{
			case ST_Igni:
				{
					if ( !theSound.SoundIsBankLoaded("monster_golem_ifryt.bnk") )
					{
						theSound.SoundLoadBank( "monster_golem_ifryt.bnk", false );
					}
				
					if ( FactsQuerySum("spells_igni_chosen_att_1") <= 0 && FactsQuerySum("spells_igni_chosen_att_2") <= 0)
					{
						if ( RandF() < 0.5 && FactsQuerySum("spells_igni_chosen_hatt_1") <=0 )
						{
							animname = 'man_mage_wind_gust_01';
							FactsAdd("spells_igni_chosen_att_1",,3);
						}
						else
						{
							animname = 'man_mage_wind_gust_02';
							FactsAdd("spells_igni_chosen_att_2",,3);
						}
					}
					else if ( FactsQuerySum("spells_igni_chosen_att_1") > 0 )
					{
						animname = 'man_mage_wind_gust_02';
						FactsAdd("spells_igni_chosen_att_2",,3);
						FactsRemove("spells_igni_chosen_att_1");
					}
					else if ( FactsQuerySum("spells_igni_chosen_att_2") > 0 )
					{
						if ( RandF() < 0.5 )
						{
							animname = 'man_mage_wind_gust_03';
							FactsAdd("spells_igni_chosen_att_3",,1);
						}
						else
						{
							animname = 'man_mage_wind_gust_01';
						
						}
						FactsAdd("spells_igni_chosen_att_1",,3);
						FactsRemove("spells_igni_chosen_att_2");
					}
					
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( animname, 'PLAYER_SLOT', parent.sett );
					/*
					parent.apply_item_hack = false;
					if ( animname == 'man_mage_wind_gust_01' )
					{
						parent.AddTimer('raise_event_hack_start', 0.3 );
						parent.AddTimer('raise_event_hack_end', 1.2 );
					}
					*/
					GetMagicEffectRight().PlayEffect('igni_light_attack_effect');
					GetMagicEffectRight().StopEffect('igni_light_attack_effect');
					
					if ( animname == 'man_mage_wind_gust_01' ) { Sleep( 0.6 ); } else { Sleep( 0.5 ); }
					
					if ( parent.actor  )
					{
						pos = parent.actor.GetWorldPosition();
						rot = thePlayer.GetWorldRotation();
						pos.Z += 0.5;
						
						if ( FactsQuerySum("spells_igni_chosen_att_3") > 0 )
						{ 
							pos.Z += 0.3;
							effname = 'left';
						}
						else if ( FactsQuerySum("spells_igni_chosen_att_1") > 0 )
						{ 
							effname = 'diagonal_up_left';
						}
						else if ( FactsQuerySum("spells_igni_chosen_att_2") > 0 )
						{
							effname = 'diagonal_up_right';
						}
						
						effect = theGame.CreateEntity( (CEntityTemplate) LoadResource( "dlc\magicspellsrev\data\entities\swordless\light_attack_igni.w2ent",true ), pos, rot );
						effect.PlayEffect( effname ); 
						effect.DestroyAfter(5);
						
						effect_entity = parent.actor.CreateFXEntityAtPelvis( 'swordless_hits', true );
						effect_entity.PlayEffect( 'igni_slash_hit' );
						effect_entity.DestroyAfter(5);
						
						effect.SoundEvent("monster_golem_ifryt_cmb_throw");
						
						deal_damage_swordless_spells( S_Magic_2, parent.actor, 6, theGame.params.DAMAGE_NAME_FIRE, false );
						
						drain_stamina_swordless_spells( ST_Igni, false );
					}
					
					
					parent.can_cast_swordless_animation = true;
					GetMagicVigil().set_can_interrupt(true);
					parent.RemoveTimer( 'rotate_towards_target_swordless' );
					
					if 		( animname == 'man_mage_wind_gust_01' ) 	{ Sleep( 1.1 ); } 
					else if ( animname == 'man_mage_wind_gust_02' ) 	{ Sleep( 0.8 ); }
					else if ( animname == 'man_mage_wind_gust_03' ) 	{ Sleep( 1.0 ); }
					
					parent.GotoState('Dreamer_Waiting');
				}
				break;
		
			case ST_Axii:
				{
					if ( !theSound.SoundIsBankLoaded("monster_golem_ice.bnk") )
					{
						theSound.SoundLoadBank( "monster_golem_ice.bnk", false );
					}
					if ( !theSound.SoundIsBankLoaded("ep2_mutations_09.bnk") )
					{
						theSound.SoundLoadBank( "ep2_mutations_09.bnk", false );
					}
					
				
					if ( FactsQuerySum("spells_left_anim_played") <= 0 && FactsQuerySum("spells_right_anim_played") <= 0 )
					{
						if ( RandF() < 0.5 )
						{
							animname = 'man_mage_force_blast_02';	// left
							FactsAdd("spells_left_anim_played",,2);
						}
						else
						{
							animname = 'man_mage_lightning_01'; 	// right
							FactsAdd("spells_right_anim_played",,2);
						}
					}
					else if ( FactsQuerySum("spells_left_anim_played") > 0 )
					{
						animname = 'man_mage_lightning_01';
						FactsRemove("spells_left_anim_played");
						FactsAdd("spells_right_anim_played",,2);
					}
					else if ( FactsQuerySum("spells_right_anim_played") > 0 )
					{
						animname = 'man_mage_force_blast_02';
						FactsRemove("spells_right_anim_played");
						FactsAdd("spells_left_anim_played",,2);
					}
					
					if ( FactsQuerySum( "force_frozenbolt_left_anim" ) >0 )
					{
						animname = 'man_mage_force_blast_02';
						FactsRemove( "force_frozenbolt_left_anim" );
						FactsRemove("spells_right_anim_played");
						FactsAdd("spells_left_anim_played",,2);
					}
					
					if ( animname == 'man_mage_lightning_01' )
					{
						effect = GetMagicEffectRight();
					}
					else if ( animname == 'man_mage_force_blast_02' )
					{
						effect = GetMagicEffectLeft();
					}
					effect.PlayEffect('axii_light_attack_effect');
					effect.StopEffect('axii_light_attack_effect');
					
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( animname, 'PLAYER_SLOT', parent.sett );
					
					Sleep(0.4);
					
					path = "dlc\magicspellsrev\data\entities\swordless\light_attack_axii_bolt.w2ent";
					frozenbolt = (W3BoltSpellsfrozen)theGame.CreateEntity( (CEntityTemplate)LoadResource( path, true ), thePlayer.GetWorldPosition() );
					frozenbolt.AddTag('spells_custom_projs');
					meshComponent = ( CMeshComponent ) frozenbolt.GetComponentByClassName( 'CMeshComponent' );
					meshComponent.SetScale( Vector( 1.6, 1, 1.6 ) );
					frozenbolt.CreateAttachment( effect,,Vector( 0.5, 0, 0 ), EulerAngles(0, -90, 0  ) );
					frozenbolt.Init(NULL);
					
					Sleep(0.2);
					
					if ( parent.actor )
					{
						frozenbolt.BreakAttachment();
						pos = parent.actor.GetBoneWorldPosition( spells_get_pelvis_name(parent.actor) );
						pos.Z += 0.3;
						frozenbolt.ShootProjectileAtPosition( 0, 20, pos  );
						frozenbolt.RemoveTimer('check_for_cancel');
						
						frozenbolt.SoundEvent("monster_golem_ice_swoosh_ADD");
						frozenbolt.SoundEvent("cmb_fistfight_swoosh_04");
						frozenbolt.SoundEvent("cmb_fistfight_swoosh_04");
						
						frozenbolt.PlayEffect('trail');
						frozenbolt.PlayEffect('trail2');
						frozenbolt.AddTimer('play_eff', 0.3, true);
						drain_stamina_swordless_spells( ST_Axii, false );
					}
					else
					{
						meshComponent.SetScale( Vector( 0, 0, 0 ) );
						frozenbolt.DestroyEffect('frozen');
						frozenbolt.Destroy();
					}
					
					parent.can_cast_swordless_animation = true;
					GetMagicVigil().set_can_interrupt(true);
					parent.RemoveTimer( 'rotate_towards_target_swordless' );
					
					Sleep(0.77);
					parent.GotoState('Dreamer_Waiting');
					
				}
				break;
			
			case ST_Aard:
				{
					if ( !theSound.SoundIsBankLoaded("monster_golem.bnk") )
					{
						theSound.SoundLoadBank( "monster_golem.bnk", false );
					}
				
					if ( FactsQuerySum("spells_aard_chosen_att_1") <= 0 && FactsQuerySum("spells_aard_chosen_att_2") <= 0)
					{
						if ( RandF() < 0.5 )
						{
							animname = 'man_mage_wind_gust_01';
							FactsAdd("spells_aard_chosen_att_1",,3);
						}
						else
						{
							animname = 'man_mage_wind_gust_02';
							FactsAdd("spells_aard_chosen_att_2",,3);
						}
					}
					else if ( FactsQuerySum("spells_aard_chosen_att_1") > 0 )
					{
						animname = 'man_mage_wind_gust_02';
						FactsAdd("spells_aard_chosen_att_2",,3);
						FactsRemove("spells_aard_chosen_att_1");
					}
					else if ( FactsQuerySum("spells_aard_chosen_att_2") > 0 )
					{
						if ( RandF() < 0.5 )
						{
							animname = 'man_mage_wind_gust_03';
							FactsAdd("spells_aard_chosen_att_3",,1);
						}
						else
						{
							animname = 'man_mage_wind_gust_01';
						
						}
						FactsAdd("spells_aard_chosen_att_1",,3);
						FactsRemove("spells_aard_chosen_att_2");
					}
					
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( animname, 'PLAYER_SLOT', parent.sett );
					
					/*
					parent.apply_item_hack = false;
					if ( animname == 'man_mage_wind_gust_01' )
					{
						parent.AddTimer('raise_event_hack_start', 0.3 );
						parent.AddTimer('raise_event_hack_end', 1.2 );
					}
					else
					{
						parent.AddTimer('raise_event_hack_start', 0 );
						parent.AddTimer('raise_event_hack_end', 1 );
					}
					*/
					//parent.AddTimer('raise_event_hack_start', StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_proj_timer' ) ) );
					//parent.AddTimer('raise_event_hack_end', StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_proj_timer2' ) ) );
					
					GetMagicEffectRight().PlayEffect('aard_light_attack_effect');
					GetMagicEffectRight().StopEffect('aard_light_attack_effect');
					
					path = "dlc\magicspellsrev\data\entities\swordless\light_attack_aard_projectile.w2ent";
					aardproj = (W3AardTrailM)theGame.CreateEntity( (CEntityTemplate)LoadResource( path, true ), thePlayer.GetWorldPosition()  );
					aardproj.AddTag('spells_custom_projs');
					aardproj.CreateAttachment( GetMagicEffectRight(), , Vector( 0.5, 0, 0 ) );
					
					Sleep(0.2);
					aardproj.Init(NULL);
					if ( animname == 'man_mage_wind_gust_01' ) { Sleep( 0.3 ); } else { Sleep( 0.2 ); }
					aardproj.PlayEffect( aardproj.name0 );
					aardproj.PlayEffect( aardproj.name1 );
					Sleep(0.1);
					if ( parent.actor )
					{
						aardproj.RemoveTimer('check_for_cancel');
						aardproj.BreakAttachment();
						pos = parent.actor.GetBoneWorldPosition( spells_get_pelvis_name(parent.actor) );
						pos.Z += 0.3;
						aardproj.ShootProjectileAtPosition( 0, 20, pos  );
						aardproj.AddTimer('check_targets_aard', 0.001, true);
						aardproj.SoundEvent("monster_golem_cmb_swoosh_heavy");
						drain_stamina_swordless_spells( ST_Aard, false );
					}
					else
					{
						aardproj.Destroy();
					}
					
					parent.can_cast_swordless_animation = true;
					GetMagicVigil().set_can_interrupt(true);
					parent.RemoveTimer( 'rotate_towards_target_swordless' );
					
					if 		( animname == 'man_mage_wind_gust_01' ) 	{ Sleep( 1.0 ); } 
					else if ( animname == 'man_mage_wind_gust_02' ) 	{ Sleep( 0.7 ); }
					else if ( animname == 'man_mage_wind_gust_03' ) 	{ Sleep( 0.9 ); }
					
					parent.GotoState('Dreamer_Waiting');
				}
				break;
			
			case ST_Quen:
				{
					if ( FactsQuerySum("spells_left_anim_played") <= 0 && FactsQuerySum("spells_right_anim_played") <= 0 )
					{
						if ( RandF() < 0.5 )
						{
							animname = 'man_mage_force_blast_02';	// left
							FactsAdd("spells_left_anim_played",,2);
						}
						else
						{
							animname = 'man_mage_lightning_01'; 	// right
							FactsAdd("spells_right_anim_played",,2);
						}
					}
					else if ( FactsQuerySum("spells_left_anim_played") > 0 )
					{
						animname = 'man_mage_lightning_01';
						FactsRemove("spells_left_anim_played");
						FactsAdd("spells_right_anim_played",,2);
					}
					else if ( FactsQuerySum("spells_right_anim_played") > 0 )
					{
						animname = 'man_mage_force_blast_02';
						FactsRemove("spells_right_anim_played");
						FactsAdd("spells_left_anim_played",,2);
					}
					
					if ( animname == 'man_mage_lightning_01' )
					{
						effect = GetMagicEffectRight();
					}
					else if ( animname == 'man_mage_force_blast_02' )
					{
						effect = GetMagicEffectLeft();
					}
					effect.PlayEffect('quen_light_attack_effect');
					effect.StopEffect('quen_light_attack_effect');
					
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( animname, 'PLAYER_SLOT', parent.sett );
					
					Sleep(0.6);
					if ( parent.actor )
					{
						effect_entity = parent.actor.CreateFXEntityAtPelvis( 'explosions', true );
						effect_entity.PlayEffect( 'old_gods_hit' );
						effect_entity.DestroyAfter(5);
						effect_entity.SoundEvent("sign_yrden_shock_activate");
					
						effect.PlayEffect( 'quen_light_attack_shot', effect_entity );
						effect.SoundEvent("sign_yrden_shock_activate");
						
						deal_damage_swordless_spells( S_Magic_4, parent.actor, 6, theGame.params.DAMAGE_NAME_SHOCK, false );
						
						drain_stamina_swordless_spells( ST_Quen, false );
					}
					
					
					parent.can_cast_swordless_animation = true;
					GetMagicVigil().set_can_interrupt(true);
					parent.RemoveTimer( 'rotate_towards_target_swordless' );
					
					Sleep(0.77);
					parent.GotoState('Dreamer_Waiting');
				}
				break;
			
			case ST_Yrden:
				{
					if ( !theSound.SoundIsBankLoaded("magic_yennefer.bnk") )
					{
						theSound.SoundLoadBank( "magic_yennefer.bnk", false );
					}
				
					if ( FactsQuerySum("spells_yrden_chosen_att_1") <= 0 && FactsQuerySum("spells_yrden_chosen_att_2") <= 0)
					{
						if ( RandF() < 0.5 )
						{
							animname = 'man_mage_wind_gust_01';
							FactsAdd("spells_yrden_chosen_att_1",,2);
						}
						else
						{
							animname = 'man_mage_wind_gust_02';
							FactsAdd("spells_yrden_chosen_att_2",,2);
						}
					}
					else if ( FactsQuerySum("spells_yrden_chosen_att_1") > 0 )
					{
						animname = 'man_mage_wind_gust_02';
						FactsAdd("spells_yrden_chosen_att_2",,2);
						FactsRemove("spells_yrden_chosen_att_1");
					}
					else if ( FactsQuerySum("spells_yrden_chosen_att_2") > 0 )
					{
						if ( RandF() < 0.5 )
						{
							animname = 'man_mage_wind_gust_03';
							FactsAdd("spells_yrden_chosen_att_3",,1);
						}
						else
						{
							animname = 'man_mage_wind_gust_01';
						
						}
						FactsAdd("spells_yrden_chosen_att_1",,2);
						FactsRemove("spells_yrden_chosen_att_2");
					}
					
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( animname, 'PLAYER_SLOT', parent.sett );
					
					GetMagicEffectRight().PlayEffect('yrden_light_attack_effect');
					GetMagicEffectRight().StopEffect('yrden_light_attack_effect');
					
					if ( animname == 'man_mage_wind_gust_01' ) { Sleep( 0.6 ); } else { Sleep( 0.5 ); }
					
					if ( parent.actor )
					{
						pos = parent.actor.GetWorldPosition();
						rot = thePlayer.GetWorldRotation();
						pos.Z += 0.5;
						
						if ( FactsQuerySum("spells_yrden_chosen_att_3") > 0 )
						{ 
							pos.Z += 1;
							effname = 'diagonal_down_left_yrden';
						}
						else if ( FactsQuerySum("spells_yrden_chosen_att_1") > 0 )
						{ 
							effname = 'diagonal_up_left_yrden';
						}
						else if ( FactsQuerySum("spells_yrden_chosen_att_2") > 0 )
						{
							effname = 'diagonal_up_right_yrden';
						}
						
						effect = theGame.CreateEntity( (CEntityTemplate) LoadResource( "dlc\magicspellsrev\data\entities\swordless\light_attack_yrden.w2ent",true ), pos, rot );
						effect.PlayEffect( effname ); 
						effect.DestroyAfter(5);
						
						effect_entity = parent.actor.CreateFXEntityAtPelvis( 'swordless_hits', true );
						effect_entity.PlayEffect( 'yrden_slash_hit' );
						effect_entity.DestroyAfter(5);
						
						thePlayer.SoundEvent("magic_yennefer_cast");
						
						deal_damage_swordless_spells( S_Magic_3, parent.actor, 6, theGame.params.DAMAGE_NAME_SHOCK, false );
						
						drain_stamina_swordless_spells( ST_Yrden, false );
					}
					
					parent.can_cast_swordless_animation = true;
					GetMagicVigil().set_can_interrupt(true);
					parent.RemoveTimer( 'rotate_towards_target_swordless' );
					
					if 		( animname == 'man_mage_wind_gust_01' ) 	{ Sleep( 1.1 ); } 
					else if ( animname == 'man_mage_wind_gust_02' ) 	{ Sleep( 0.8 ); }
					else if ( animname == 'man_mage_wind_gust_03' ) 	{ Sleep( 1.0 ); }
					
					parent.GotoState('Dreamer_Waiting');
				}
				break;
				
			default:		
				break;
		}
	}
}

state Swordless_AttackHeavy in W3MagicDreamer
{
	var animname							: name;
	var effect								: CEntity;
	var frostgranade 						: W3MFrostGranade;
	var quen_sphere 						: W3MQuenSphere;
	var swordlessHeavy 						: CSwordlessHeavy;
	var meshComponent 						: CMeshComponent;
	var path								: string;
	var pos 								: Vector;
	var rot 								: EulerAngles;
	var effname								: name;
	var effect_entity						: CEntity;

	event OnEnterState( prevStateName : name )
	{	
		parent.AddTimer('rotate_towards_target_swordless', 0.01, true );
		
		parent.sett.blendIn = 0.5f;
		parent.sett.blendOut = 0.5f;
	
		parent.can_cast_swordless_animation = false;
		swordless_heavy_attack();
		
	}


	private entry function swordless_heavy_attack()
	{
		switch( GetWitcherPlayer().GetEquippedSign() )
		{
			case ST_Igni:
				{
					parent.AddTimer('find_target_ag', 0.01, true );
					
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_mage_sand_cage_01_2', 'PLAYER_SLOT', parent.sett );
					
					path = "dlc\magicspellsrev\data\entities\swordless\heavy_attack_aard_slow.w2ent";
					swordlessHeavy = (CSwordlessHeavy)theGame.CreateEntity( (CEntityTemplate) LoadResource (path, true), thePlayer.GetWorldPosition() );
					swordlessHeavy.CreateAttachment( thePlayer, 'r_weapon' );
					swordlessHeavy.AddTag('swordless_heavy_fx_ent');
					
					Sleep(0.5);
					swordlessHeavy.initiate( ST_Igni );
					
					Sleep(3.0);
					swordlessHeavy.AddTimer('destroy_sw_heavy', 0 );
					
					parent.can_cast_swordless_animation = true;
					GetMagicVigil().set_can_interrupt(true);
					
					Sleep( 1.2 );
					parent.GotoState('Dreamer_Waiting');
				}
				break;
		
			case ST_Aard:
				{
					parent.AddTimer('find_target_ag', 0.01, true );
					
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_mage_sand_cage_01_2', 'PLAYER_SLOT', parent.sett );
					
					path = "dlc\magicspellsrev\data\entities\swordless\heavy_attack_aard_slow.w2ent";
					swordlessHeavy = (CSwordlessHeavy)theGame.CreateEntity( (CEntityTemplate) LoadResource (path, true), thePlayer.GetWorldPosition() );
					swordlessHeavy.CreateAttachment( thePlayer, 'r_weapon' );
					swordlessHeavy.AddTag('swordless_heavy_fx_ent');
					
					Sleep(0.5);
					swordlessHeavy.initiate( ST_Aard );
					
					Sleep(3.0);
					swordlessHeavy.AddTimer('destroy_sw_heavy', 0 );
					
					parent.can_cast_swordless_animation = true;
					GetMagicVigil().set_can_interrupt(true);
					
					Sleep( 1.2 );
					parent.GotoState('Dreamer_Waiting');
				}
				break;
				
			case ST_Axii:
				{
					if ( !theSound.SoundIsBankLoaded("monster_golem_ifryt.bnk") )
					{
						theSound.SoundLoadBank( "monster_golem_ifryt.bnk", false );
					}
					if ( !theSound.SoundIsBankLoaded("ep2_mutations_06.bnk") )
					{
						theSound.SoundLoadBank( "ep2_mutations_06.bnk", false );
					}
				
					parent.apply_item_hack = false;
				
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_mage_fireball_01_2', 'PLAYER_SLOT', parent.sett );
					
					path = "dlc\magicspellsrev\data\entities\swordless\heavy_attack_axii_frostproj.w2ent";
					frostgranade = (W3MFrostGranade)theGame.CreateEntity( (CEntityTemplate)LoadResource(path, true ), thePlayer.GetWorldPosition() );
					frostgranade.AddTag('spells_custom_projs');
					frostgranade.CreateAttachment( GetMagicEffectLeft(),,Vector( 0.5, 0, 0 ) );
					frostgranade.Init(NULL);
					frostgranade.AddTag('frost_granade_spell');
					
					Sleep(0.5);
					frostgranade.BreakAttachment();
					frostgranade.CreateAttachment( GetMagicEffectRight(),,Vector( 0.5, 0, 0 ) );
					
					Sleep(0.1);
					thePlayer.SetBehaviorVariable( 'SelectedItemL', (int)UI_Torch, true );	
					thePlayer.RaiseEvent( 'ItemUseL' );
					thePlayer.SetUsableItemLtransitionAllowed ( false );
					parent.apply_item_hack = true;
					parent.AddTimer('raise_event_hack_end', 2 );
						
					Sleep(1.05);
					if ( parent.actor )
					{
						frostgranade.RemoveTimer('check_for_cancel');
						frostgranade.BreakAttachment();
						pos = parent.actor.GetWorldPosition();
						pos.Z += 1;
						frostgranade.ShootProjectileAtPosition( 5, 10, pos  );
						frostgranade.PlayEffect( 'fire_fx3' );
						frostgranade.AddTimer('play_eff', 0.3);
						frostgranade.AddTimer('play_eff1', 0.1);
						frostgranade.AddTimer('check_targets', 0.001, true);
						frostgranade.SoundEvent("monster_golem_ifryt_cmb_swoosh_heavy");
						
						drain_stamina_swordless_spells( ST_Axii, true );
					}
					else
					{
						frostgranade.SoundEvent("fx_fire_burning_strong_end");
						frostgranade.SoundEvent("fx_fire_burning_body_strong_loop_end");
						frostgranade.RemoveTimers();
						frostgranade.StopAllEffects();
						frostgranade.DestroyAfter(3);
					}
					parent.RemoveTimer( 'rotate_towards_target_swordless' );
					FactsAdd("force_frozenbolt_left_anim",,3);
					
					parent.can_cast_swordless_animation = true;
					GetMagicVigil().set_can_interrupt(true);
					
					Sleep(1.35);
					//3
					parent.GotoState('Dreamer_Waiting');
					
				}
				break;
				
			case ST_Quen:
				{
					parent.RemoveTimer( 'rotate_towards_target_swordless' );
				
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_mage_tornado_01_end', 'PLAYER_SLOT', parent.sett );
				
					path = "dlc\magicspellsrev\data\entities\swordless\heavy_attack_quen_sphere.w2ent";
					quen_sphere = (W3MQuenSphere)theGame.CreateEntity( (CEntityTemplate)LoadResource( path ,true), thePlayer.GetWorldPosition() );
					quen_sphere.CreateAttachment( GetMagicEffectLeft(),,Vector( 0.55, 0, 0 ) );
					quen_sphere.AddTimer('destroy_sphere',14);
					quen_sphere.AddTag('quen_sphere_fists');
					quen_sphere.PlayEffect('fire_fx_quen');
					
					GetMagicEffectLeft().PlayEffect('quen_light_attack_effect');
					GetMagicEffectLeft().StopEffect('quen_light_attack_effect');
					
					Sleep (0.3);
					GetMagicEffectRight().PlayEffect('quen_heavy_attack_effect');
					GetMagicEffectRight().StopEffect('quen_heavy_attack_effect');
					Sleep (0.6);
					quen_sphere.fly_away_little_sphere();
					
					drain_stamina_swordless_spells( ST_Quen, true );
					
					parent.can_cast_swordless_animation = true;
					GetMagicVigil().set_can_interrupt(true);
					
					Sleep(0.6);
					parent.GotoState('Dreamer_Waiting');
				}
				break;
			
			case ST_Yrden:
				{
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_mage_force_blast_01', 'PLAYER_SLOT', parent.sett );

					GetMagicEffectLeft().PlayEffect('yrden_heavy_shot_effect');
					GetMagicEffectRight().PlayEffect('yrden_heavy_shot_effect');
					GetMagicEffectLeft().StopEffect('yrden_heavy_shot_effect');
					GetMagicEffectRight().StopEffect('yrden_heavy_shot_effect');
					
					Sleep(0.4);
					
					if ( parent.actor )
					{
						GetMagicEffectLeft().SoundEvent("sign_yrden_shock_activate");
						GetMagicEffectRight().SoundEvent("sign_yrden_shock_activate");
					
						effect_entity = parent.actor.CreateFXEntityAtPelvis( 'sword_ring_small_effects', true );
						effect_entity.PlayEffect( 'yrden_shock_cut' );
						effect_entity.DestroyAfter(5);
						effect_entity.SoundEvent("sign_yrden_shock_activate");
						
						GetMagicEffectLeft().PlayEffect('yrden_heavy_attack_shot', effect_entity );
						GetMagicEffectRight().PlayEffect('yrden_heavy_attack_shot', effect_entity );
						
						deal_damage_swordless_spells( S_Magic_3, parent.actor, 6, theGame.params.DAMAGE_NAME_SHOCK, true );
						drain_stamina_swordless_spells( ST_Yrden, true );
					}
					
					parent.can_cast_swordless_animation = true;
					GetMagicVigil().set_can_interrupt(true);
					parent.RemoveTimer( 'rotate_towards_target_swordless' );
					
					Sleep( 0.95 );
					
					parent.GotoState('Dreamer_Waiting');
				}
				break;
				
			default:		
				break;
		}
	}
}